﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;

namespace AZVIC.Ei8htPOS.Utilities
{
    public static class ValidationUtility
    {
        public static bool ValidateString(string value)
        {
            if (string.IsNullOrEmpty(value.Trim()))
            {
                return false;
            }
            return true;
        }

        public static bool ValidateWebsite(string webURL)
        {
            if (!string.IsNullOrEmpty(webURL.Trim()))
            {
                string strRegex = @"http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&amp;=]*)?";//@"^(((h|H?)(t|T?)(t|T?)(p|P?)(s|S?))\://)?(www.|[a-zA-Z0-9].)[a-zA-Z0-9\-\.]+\.[a-zA-Z]*$";
                System.Text.RegularExpressions.Regex re = new System.Text.RegularExpressions.Regex(strRegex);
                if (!re.IsMatch(webURL.Trim()))
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
            return true;
        }

        public static bool ValidateEmail(string email)
        {
            if (!string.IsNullOrEmpty(email.Trim()))
            {
                string strRegex = @"\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*";
                System.Text.RegularExpressions.Regex re = new System.Text.RegularExpressions.Regex(strRegex);
                if (!re.IsMatch(email.Trim()))
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
            return true;
        }

        public static bool ValidateDate(string datestring, string dateformate)
        {
            try
            {
                DateTime.ParseExact(datestring.Trim(), dateformate, null);
            }
            catch { return false; }
            return true;
        }

        public static bool ValidateInt(string value)
        {
            try
            {
                int.Parse(value.Trim());
            }
            catch { return false; }
            return true;
        }

        public static bool ValidateDecimal(string value)
        {
            try
            {
                decimal.Parse(value.Trim());
            }
            catch { return false; }
            return true;
        }

        public static bool ValidatephoneNo(/*string countryCode, string areaCode,*/ string phoneNo)
        {
            string numberPattern = "^[0-9]*$";

            //countryCode = countryCode.Replace("+", "").Replace("-", "");
            //areaCode = areaCode.Replace("+", "").Replace("-", "");
            phoneNo = phoneNo.Replace("+", "").Replace("-", "");

            if (/*countryCode.Length == 0 || areaCode.Length == 0 || */phoneNo.Length == 0)
                return false;
            else
            {
                /*Match match1 = Regex.Match(countryCode.Trim(), numberPattern, RegexOptions.IgnoreCase);
                Match match2 = Regex.Match(areaCode.Trim(), numberPattern, RegexOptions.IgnoreCase);*/
                Match match3 = Regex.Match(phoneNo.Trim(), numberPattern, RegexOptions.IgnoreCase);
                if (/*!match1.Success || !match2.Success || */!match3.Success)
                    return false;
            }
            return true;
        }

        public static bool IsValidImageFile(string fileName)
        {
            string[] fileExtensions = { ".bmp", ".jpg", ".png", ".gif", ".jpeg" };
            string extensions = Path.GetExtension(fileName).ToLower();

            if (fileExtensions.Contains(extensions))
                return true;

            return false;
        }

        public static bool IsValidDocumentFile(string fileName)
        {
            string[] fileExtensions = { ".pdf", ".zip", ".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx" };
            string extensions = Path.GetExtension(fileName).ToLower();

            if (fileExtensions.Contains(extensions))
                return true;

            return false;
        }

        public static string ValidatePassword(string password)
        {
            if (password.Trim().Length < 8)
                return "Password must be 8 to 24 characters";
            else if (password.Trim().Length > 24)
                return "Password must be 8 to 24 characters";
            return string.Empty;
        }

        public static string GetCipherText(string stringToCipher)
        {
            return string.Empty;
        }

        public static string GetDecipherText(string cipherToString)
        {
            return string.Empty;
        }

        public static string EncryptPassword(string password)
        {
            return Encrypto.CipherText(password);
        }

        public static string DecryptPassword(string cipher)
        {
            return Encrypto.DecipherText(cipher);
        }

        public static string ReplaceWildcardCharactersForSQL(string value)
        {
            value = value.Replace("_", "[_]").Replace("%", "[%]");
            return value;
        }
    }
}
